<?php

namespace Librerias;

use Helpers\Http;

final class FrontController
{
    private static $ruta;

    public static function inicio()
    {
        [$controlador, $metodo, $argumento] = Router::analizarUri();

        self::$ruta = 'app/' . strtolower($controlador) . '/controlador/' . ucfirst($controlador) . 'Controlador.php';

        $controladorNombre = ucwords($controlador) . 'Controlador';

        if (file_exists(self::$ruta)) {
            $class = "App\\Controladores\\{$controladorNombre}";
            $obj = new $class();

            if (is_callable([$obj, $metodo]) and method_exists($obj, $metodo)) {
                call_user_func([$obj, $metodo], $argumento);
            } else {
                Http::notFound();
            }
        } else {
            Http::notFound();
        }
    }
}
