<?php

namespace Helpers;

use Librerias\Database;
use Librerias\SessionManager;

final class Menu
{
    private $menu_id;
    private $db_con;

    public function __construct($menu_id = null)
    {
        SessionManager::verificarSession();

        $this->db_con = new Database();

        if (null !== $menu_id && !$this->has_menu_permission($menu_id, $_SESSION['user_data']['user_id'])) {
            Http::exit_by_forbiden();
        }
    }

    public function has_menu_permission($menu_id, $user_id)
    {
        $data = $this->db_con->consultar("SELECT * FROM app_permiso_menu WHERE pm_menuid = '$menu_id' AND pm_userid = $user_id")->row();
        return ($data) ? true : false;
    }

    public function getmenuName(string $menu_id)
    {
        return $this->db_con->consultar("SELECT * FROM app_menus WHERE menu_id = '$menu_id'")->row();
    }

    public function getAllmenus()
    {
        return $this->db_con->consultar('SELECT * FROM app_menus ORDER BY menu_orden')->all();
    }

    public function getAllowedmenus(int $user_id)
    {
        return $this->db_con->consultar("SELECT * FROM app_menus 
        JOIN app_permiso_menu on app_permiso_menu.pm_menuid=app_menus.menu_id 
        WHERE app_permiso_menu.pm_userid = $user_id AND app_menus.menu_bloqueado=0 AND app_menus.menu_parentid IS NULL 
        ORDER BY menu_orden ASC")->all();
    }

    public function getAllowedSubmenus(string $user_id, string $menu_parentid)
    {
        return $this->db_con->consultar("SELECT * FROM app_menus 
        JOIN app_permiso_menu on app_permiso_menu.pm_menuid=app_menus.menu_id 
        WHERE app_menus.menu_parentid = '{$menu_parentid}' AND app_permiso_menu.pm_userid = $user_id ORDER BY menu_orden ASC")->all();
    }

    public function countHaveSubMenu(string $user_id, string $menu_parentid)
    {
        return $this->db_con->consultar("SELECT * FROM app_menus 
        JOIN app_permiso_menu on app_permiso_menu.pm_menuid=app_menus.menu_id 
        WHERE app_menus.menu_parentid = '{$menu_parentid}' AND app_permiso_menu.pm_userid = $user_id")->count();
    }

    public function check_action_permission(string $action_id)
    {
        if (!$this->has_menu_action_permission($this->menu_id, $action_id, $_SESSION['user_data']['user_id'])) {
            header('Location:' . ruta_base() . '403');
            exit;
        }
    }

    public function has_menu_action_permission($menu_id, string $action_id, int $user_id)
    {
        $data = $this->db_con->consultar("SELECT * FROM app_permiso_accion WHERE pa_userid = $user_id AND pa_menuid = '$menu_id' AND pa_accionid = '$action_id'")->row();
        return ($data) ? true : false;
    }

    public function getmenuUser(string $modulo_id, int $user_id)
    {
        $data = $this->db_con->consultar("SELECT * FROM app_menus 
        JOIN app_permiso_menu on app_permiso_menu.pm_menuid=app_menus.menu_id 
        WHERE app_permiso_menu.pm_userid = $user_id and app_permiso_menu.pm_menuid='$modulo_id'
         ORDER BY sort ASC")->row();
        return ($data) ? true : false;
    }
}
