<?php

namespace Helpers;

final class Token
{
    public static function verificaToken()
    {
        $redirect = new Redirecciona();

        if (!isset($_SESSION['csrf'][CSRF_TOKEN . '_token']) || $_SESSION['csrf'][CSRF_TOKEN . '_token']['token'] !== $_POST['token']) {
            $redirect->mensaje([
                'mensaje' => 'El intento de acceso no es valido y/o expiro, <br /> Refresque e intente de nuevo',
                'tipo' => 'error',
            ])->atras();
            exit();
        }

        return true;
    }

    public static function crearToken()
    {
        $token = md5(uniqid(microtime(), true));
        $token_time = time();
        $_SESSION['csrf'][CSRF_TOKEN . '_token'] = ['token' => $token, 'time' => $token_time];

        return $token;
    }
}
